/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: OmbOmbApTask_Functionlist.h 5427 2016-04-08 13:03:36Z Alexander.Ivanov $:
Description:
Omb Application Task
Includes following functions...
**************************************************************************************/

/**
 * @file OmbOmbApTask_Functionlist.h
 * @brief Omb OmbApTask - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_OmbOmbApTask</code>
 * of task.
 */
#ifndef __OMB_OMBAPTASK_FUNCTIONLIST_H
#define __OMB_OMBAPTASK_FUNCTIONLIST_H

#include "TLR_Includes.h"

/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_OmbOmbApTask
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_OmbOmbApTask
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_OmbOmbApTask
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define OMB_OMBAPTASK_STARTUP_PARAM_VERSION_V4  (4)

/* TLR_CHAR      szCommandTableQueueName[16]    */
/* TLR_UINT32    ulCommadTableInstance          */

/** Limits, bitsmasks of the startup parameter */

/*** Queue, pool element sizes ***/
/* Min/Default/Max OMB AP tasks process queue size for packets (ulQueElemCnt) */
#define OMBAP_SRT_QUE_ELEM_CNT_MIN            (16)    /* 1 per socket         */
#define OMBAP_SRT_QUE_ELEM_CNT_DEFAULT        (64)    /* Suggestion: 4 per    */
                                                      /* socket (4 * 16)      */
#define OMBAP_SRT_QUE_ELEM_CNT_MAX            (4096)  /* 64 times of _DEFAULT */

/* Min/Default/Max pool element count (ulPoolElemCnt)                         */
#define OMBAP_SRT_POOL_ELEM_CNT_MIN           (16)    /* 1 per socket         */
#define OMBAP_SRT_POOL_ELEM_CNT_DEFAULT       (32)    /* Suggestion: 2 per    */
                                                      /* socket (2 * 16)      */
#define OMBAP_SRT_POOL_ELEM_CNT_MAX           (2048)  /* 64 times of _DEFAULT */


/*** OMB AP task configuration ***/
/* Start flags (ulStartFlags)                                                 */
#define OMBAP_SRT_FLAG_NONE                   (0x00000000L) /* Default value  */
      /* for no start flags defined                                           */

#define OMBAP_SRT_FLAG_TCP_TASK_SEARCH        (0x00000001L) /* Use diff. TCP  */
      /* If this falg is set, the OMB task will search for the TCPIP also on  */
      /* instance 0..6 and not only on the same instance like the OMB task    */
      /* This flag should be set only in special cases when the TCP task is   */
      /* not placed on same instance like the OMB task. Normaly the TCP task  */
      /* should have the same instance like the OMB task.                     */

#define OMBAP_SRT_FLAG_RESEVERD               (0xFFFFFFFE)
      /* !!Add new flags also by startup-parameter check in module            */
      /* xx_Resources.c, function xx_InitLocal()!!                            */
      /* and modify the reserved falg field                                   */

/* Channel instance of Dualport-memory (ulChnInst)                            */
#define OMBAP_SRT_CHN_INST_MIN                (0)
#define OMBAP_SRT_CHN_INST_DEFAULT            (0)
#define OMBAP_SRT_CHN_INST_MAX                (3)     /* 4 channels           */


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** LED instance */
typedef struct OMB_OMBAPTASK_LED_CONFIG_Ttag  OMB_OMBAPTASK_LED_CONFIG_T;

struct OMB_OMBAPTASK_LED_CONFIG_Ttag
{
  STRING      szName[16];
  TLR_UINT32  ulLedInst;
};

/** task startup parameter */
typedef struct OMB_OMBAPTASK_STARTUPPARAMETER_Ttag  OMB_OMBAPTASK_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct OMB_OMBAPTASK_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;


  /* -------------------------------------------------------------------------- */
  /* OMB_OMBAPTASK_STARTUP_PARAM_VERSION_V2     (OMBAP task version V2.0)       */
  /* -------------------------------------------------------------------------- */

  /*** Queue, pool element sizes ***/
  TLR_UINT32    ulQueElemCnt;   /* OMB AP tasks process queue size              */
                                /* Range: OMBAP_SRT_QUE_ELEM_CNT_MIN ...        */
                                /* OMBAP_SRT_QUE_ELEM_CNT_MAX                   */

  TLR_UINT32    ulPoolElemCnt;  /* Size of pool elements for indication packets */
                                /* to AP. One pool element allocates (approx.)  */
                                /* 1524 bytes                                   */
                                /* Range: OMBAP_SRT_POOL_ELEM_CNT_MIN  ...      */
                                /*        OMBAP_SRT_POOL_ELEM_CNT_MAX           */


  /*** OMBAP Task configuration ***/
  TLR_UINT32    ulStartFlags;   /* Start flags (see OMBAP_SRT_FLAG_xx above)    */

  TLR_UINT32    ulChnInst;      /* Channel instance (Dualport-memory)           */
                                /* Range: OMBAP_SRT_CHN_INST_MIN ...            */
                                /*        OMBAP_SRT_CHN_INST_MAX                */

  /* LEDs */
  OMB_OMBAPTASK_LED_CONFIG_T  tLedRunGreen; /* RUN LED - green  */
  OMB_OMBAPTASK_LED_CONFIG_T  tLedRunRed;   /* RUN LED - red    */

  OMB_OMBAPTASK_LED_CONFIG_T  tLedErrGreen; /* ERR LED - green  */
  OMB_OMBAPTASK_LED_CONFIG_T  tLedErrRed;   /* ERR LED - red    */

  TLR_CHAR      szCommandTableQueueName[16];
  TLR_UINT32    ulCommadTableInstance;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __OMB_OMBAPTASK_FUNCTIONLIST_H */
